<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
use Slim\Factory\AppFactory;
use Slim\Views\Twig;
use Slim\Views\TwigMiddleware;

require __DIR__ . '/vendor/autoload.php';
foreach(glob(__DIR__ . '/src/config/*.php') as $config){ require_once $config; };

$app = AppFactory::create();
// $app->response->headers->set('Expires', 'Sun, 01 Jan 2014 00:00:00 GMT');
// $app->response->headers->set('Cache-Control', 'no-store, no-cache, must-revalidate');
// $app->response->headers->set('Cache-Control', 'post-check=0, pre-check=0');
// $app->response->headers->set('Pragma', 'no-cache');

$app->setBasePath(BASEPATH);

$twig = Twig::create(__DIR__.'/src/layouts', ['cache' => false]);

$app->add(TwigMiddleware::create($app, $twig));

$app->addRoutingMiddleware();
$app->addBodyParsingMiddleware();


$app->addErrorMiddleware(true,true,true);

foreach(glob(__DIR__ . '/src/routes/*.php') as $route){
    $routes = require_once $route;
    $routes($app);
};

$app->run();